program odf2pdf;

{$APPTYPE CONSOLE}
{$R *.res}

uses
  System.SysUtils,
  classes,
  synpdf,
  vcl.graphics,
  System.zip,
  synzip,
  odf2pdflibrary in 'odf2pdflibrary.pas';

var
  eedoc: TEEPDFDocument;

procedure FillParameters(ee: TEEPDFDocument);
begin
  ee.replacements.Clear;
  ee.replacements.Values['salutation'] := 'Dr';
  ee.replacements.Values['firstname'] := 'Thomas';
  ee.replacements.Values['surname'] := 'Smith';
  ee.replacements.Values['employeeid'] := '123345';
  ee.replacements.Values['dobmmddyy'] := '090266';
  ee.replacements.Values['street'] := '200 University Ave';
  ee.replacements.Values['city'] := 'Waterloo';
  ee.replacements.Values['province'] := 'Ontario';
  ee.replacements.Values['country'] := 'Canada';
  ee.replacements.Values['postalcode'] := 'N2L 3G1';
  ee.replacements.Values['startdatemmddyyyy'] := '09232020';
  ee.replacements.Values['chairdirector'] := 'Georgia Smythe';
  ee.replacements.Values['salary'] := '$100,000';
  ee.replacements.Values['dutiesdescription'] := 'Fun job';
end;

procedure ShowFailures( ee : TEEPDFDocument );
var
  i : integer;
begin
  if ee.replacementserror.Count = 0 then writeln('No concerns')
  else begin
    writeln('The following replacements were empty or missing:');
    for i := 0 to ee.replacementserror.Count -1 do
       writeln('   ', ee.replacementserror[i] );
  end;
end;

const
  fn = 'sample.pdf';

begin
  reportmemoryleaksonshutdown := True;
  eedoc := TEEPDFDocument.Create(false, 0, false,
{$IFDEF USE_PDFSECURITY}TPdfEncryption.New(elRC4_40, '', 'toto',
    PDF_PERMISSION_NOMODIF){$ENDIF});
  try
    eedoc.PaperSize := psLetter;
    eedoc.Font := 'Arial';

//  Set fixedfontsize if you just want Line Printer-styled output
//    eedoc.fixedfontsize := True;

    eedoc.LoadFromODT('sample.odt');
    eedoc.Fontsize := 9;

    FillParameters(eedoc);
    eedoc.GeneratePDF;
    Showfailures( eedoc );

    if fileexists(fn) then
    DeleteFile(fn);
      eedoc.savetofile(fn);


  except
    on E: Exception do
      writeln(E.message);
  end;
  eedoc.Free;
  writeln('got to end, pdf should be ready now');
end.
