VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Get ID3 Tag Info"
   ClientHeight    =   5430
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   5430
   ScaleWidth      =   4680
   StartUpPosition =   3  'tιw]
   Begin VB.CommandButton Command1 
      Caption         =   "Print ID3Tag"
      Height          =   300
      Left            =   3000
      TabIndex        =   0
      Top             =   240
      Width           =   1335
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function GetShortPathName Lib "kernel32" Alias "GetShortPathNameA" (ByVal lpszLongPath As String, ByVal lpszShortPath As String, ByVal cchBuffer As Long) As Long

Private Type H_ID3_V1 'ID3 V1.0 header
    Title As String * 30
    Artist As String * 30
    Album As String * 30
    S_Year As String * 4
    Comment As String * 30
    Genre As Byte
End Type

Private Type H_ID3_V1_1 'ID3 V1.1 header
    Title As String * 30
    Artist As String * 30
    Album As String * 30
    S_Year As String * 4
    Comment As String * 28
    Zero As Byte
    Track As Byte
    Genre As Byte
End Type

Private Type H_ID3_V2_3 'ID3V2 3.0 header
    Flag As Byte
    TagSz As Long
End Type

Private Type H_ID3_Ext
    ExtSz As Long
    Flag As Integer
    SzPadd As Long
End Type

Private Type H_ID3_Frame
    Id As String * 4
    Sz As Long
    Status As Byte
    Encoding As Byte
End Type

Private Type ID3_V2_3_Song_Info
    Title As String
    Artist As String
    Album As String
    S_Year As String
    Comment As String
    Track As String
    Genre As String
    Composer As String
    Orig_Artist As String
    CopyRight As String
    URL As String
    EncodeBy As String
End Type

Dim IsId3V1_1 As Byte
Dim SongInfo As ID3_V2_3_Song_Info
Dim Genre_L() As String
Dim ID3_Frame As H_ID3_Frame
Dim Id3V1 As H_ID3_V1
Dim Id3V1_1 As H_ID3_V1_1
Dim Id3V2_3 As H_ID3_V2_3
Dim Id3Tag As String * 3


Private Sub Command1_Click()
Dim F As Integer
Dim Sh_Path As String
Dim n As Integer
Dim MajorVer As Byte
Dim MinorVer As Byte
F = FreeFile
Sh_Path = String(255, 0)
n = GetShortPathName("D:\My Music\07.mp3", Sh_Path, 255)
Sh_Path = Left(Sh_Path, n)
Open Sh_Path For Binary As #F
    Get #F, , Id3Tag
    If Id3Tag = "ID3" Then
        Get #F, , MajorVer
        Get #F, , MinorVer
        If MajorVer = 3 And MinorVer = 0 Then
            Get #F, , Id3V2_3
            ProcssFrame F
        End If
    End If
    Get #F, LOF(F) - 127, Id3Tag
    If Id3Tag = "TAG" Then
        Get #F, LOF(F) - 2, IsId3V1_1
        Seek #F, LOF(F) - 124
            If IsId3V1_1 = 0 Then
                Get #F, , Id3V1_1
                Print "ID3V1.1 Tag Information"
                Print "Title: " & RTrim(Id3V1_1.Title)
                Print "Artist: " & RTrim(Id3V1_1.Artist)
                Print "Album: " & RTrim(Id3V1_1.Album)
                Print "Year: " & RTrim(Id3V1_1.S_Year)
                Print "Comment: " & RTrim(Id3V1_1.Comment)
                Print "Track: " & RTrim(Id3V1_1.Track)
                If Id3V1.Genre <= UBound(Genre_L) Then Print "Genre: " & Genre_L(Id3V1_1.Genre)
                Print "-------------------------------------"
            Else
                Get #F, , Id3V1
                Print "ID3V1 Tag Information"
                Print "Title: " & RTrim(Id3V1.Title)
                Print "Artist: " & RTrim(Id3V1.Artist)
                Print "Album: " & RTrim(Id3V1.Album)
                Print "Year: " & RTrim(Id3V1.S_Year)
                Print "Comment: " & RTrim(Id3V1.Comment)
                If Id3V1.Genre <= UBound(Genre_L) Then Print "Genre: " & Genre_L(Id3V1.Genre)
                Print "-------------------------------------"
            End If
    End If
Close F

End Sub



Private Sub Form_Load()
Dim F As Integer
Dim n As Integer
Dim tmp As String
F = FreeFile
n = 0
Open App.Path & "\genre.txt" For Input As #F
Do
    ReDim Preserve Genre_L(n) As String
    Line Input #F, tmp
    Genre_L(n) = Right(tmp, Len(tmp) - InStr(tmp, "."))
    n = n + 1
Loop Until EOF(F) = True
Close F
End Sub

Sub ProcssFrame(ByVal F As Integer)
Dim TByte() As Byte
Dim TStr As String
Dim BArr(3) As Byte
Dim n As Integer
Do
DoEvents
    Get #F, , ID3_Frame.Id
    Get #F, , BArr
    ProcessSz BArr
    Get #F, , ID3_Frame.Status
    Get #F, , ID3_Frame.Encoding
    ReDim TByte(0) As Byte
    If Asc(Left(ID3_Frame.Id, 1)) = 0 Then Exit Do
    Select Case ID3_Frame.Id
        Case "TIT2"
            SongInfo.Title = Input(ID3_Frame.Sz, #F)
        Case "TPE1"
            SongInfo.Artist = Input(ID3_Frame.Sz, #F)
        Case "TALB"
            SongInfo.Album = Input(ID3_Frame.Sz, #F)
        Case "TYER"
            SongInfo.S_Year = Input(ID3_Frame.Sz, #F)
        Case "COMM"
            Get #F, , TByte
            Get #F, , TByte
            Get #F, , TByte
            Get #F, , TByte
            SongInfo.Comment = Input(ID3_Frame.Sz - 4, #F)
        Case "TRCK"
            SongInfo.Track = Input(ID3_Frame.Sz, #F)
        Case "TCON"
            SongInfo.Genre = Input(ID3_Frame.Sz, #F)
        Case "TCOM"
            SongInfo.Composer = Input(ID3_Frame.Sz, #F)
        Case "TOPE"
            SongInfo.Orig_Artist = Input(ID3_Frame.Sz, #F)
        Case "TCOP"
            SongInfo.CopyRight = Input(ID3_Frame.Sz, #F)
        Case "WXXX"
            Get #F, , TByte
            SongInfo.URL = Input(ID3_Frame.Sz - 1, #F)
        Case "TENC"
            SongInfo.EncodeBy = Input(ID3_Frame.Sz, #F)
        Case Else
            ReDim TByte(ID3_Frame.Sz - 1) As Byte
            Get #F, , TByte
    End Select
Loop
Print "ID3V2 3.0 Tag Information"
Print "Title: " & SongInfo.Title
Print "Artist: " & SongInfo.Artist
Print "Album: " & SongInfo.Album
Print "Year: " & SongInfo.S_Year
Print "Comment: " & SongInfo.Comment
Print "Track: " & SongInfo.Track
Print "Genre: " & SongInfo.Genre
Print "Composer: " & SongInfo.Composer
Print "Original Artist: " & SongInfo.Orig_Artist
Print "Copyright :" & SongInfo.CopyRight
Print "URL: " & SongInfo.URL
Print "Encode by: " & SongInfo.EncodeBy
Print "-------------------------------------"
End Sub

Sub ProcessSz(BArr() As Byte)
ID3_Frame.Sz = UBin(TTB(BArr(0)) & TTB(BArr(1)) & TTB(BArr(2)) & TTB(BArr(3)))
End Sub

Function TTB(n As Byte) As String
Dim i, j As Integer
i = 0
Do Until 2 ^ i > n
i = i + 1
Loop
For j = i - 1 To 0 Step -1
If n >= 2 ^ j Then
TTB = TTB & "1"
n = n - 2 ^ j
Else
TTB = TTB & "0"
End If
Next j
End Function


Private Function UBin(Key As String) As Long
Dim i As Integer
Dim hot As String
For i = 1 To Len(Key)
hot = Mid(Key, i, 1)
  If hot <> "0" Then
    If hot <> "1" Then
      Exit Function
    End If
  End If
Next i
For i = 1 To Len(Key)
    UBin = UBin + Val(Mid(Key, i, 1)) * 2 ^ (Len(Key) - i)
Next i
End Function
