/**
 * Boot-loader code example 
 * @author: Copyright 2009,2010 Thomas Reidemeister
 * @date: 2009.12.14
 * @file: bootloader.c
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "debug.h"
#include "shared.h"

/* declare dynamically loaded array as function pointer
 * see tmp.c and srec_to_c.py
 * they reside at the address declared in the linker script.
 */
extern int __TEST_CODE__();
extern unsigned char * code;

/**
 * Main entry point for program.
 */
int main(void)
{
    debug_puts("Inside boot-loader test suite!\r\n");

    /* perform test (dynamically generated test.c)
     * usually this stuff gets loaded somewhere
     */
    __TEST_CODE__();

    debug_puts("Inside boot-loader again!\r\n");
    
    return 0;
}

