/**
 * Boot-loader code example 
 * @author: Copyright 2009,2010 Thomas Reidemeister
 * @date: 2009.12.14
 * @file: bootloader.ld
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
MEMORY
{
  sram     : ORIGIN = 0x10200000, LENGTH = 1M
}

/* firmware's test registration routine */
__REGISTER_TEST__ = 0x10300000;
/* symbol for the dynamic code */
__TEST_CODE__     = 0x10400000;

SECTIONS
{
  .text :
  {
    *(.text)
    . = ALIGN(0x4);
    *(.rodata*)
  } > sram

  .data BLOCK(0x4) :
  {
    *(.data)
  } > sram

  .bss BLOCK(0x4) :
  {
    *(.bss)
  } > sram
  
  /* section for the dynamic code */
  __TEST_CODE__ 0x10400000:
  {
    *(__TEST_CODE__)
  }
}
