## Example for merging S19/SREC files
# @author: Copyright 2009,2010 Thomas Reidemeister
# @date: 2009.12.14
# @file: merge.py
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
import sys

def read_srecord(fname):
    buffer = """/** Automatically generated C source
 * by srec_to_c.py
 */
 
unsigned char __attribute__ ((section("__TEST_CODE__")))code [] = {
"""
    f = open(fname, 'r')
    for record in f:
        # identify description record
        if record.startswith("S0"):
            # see: http://www.amelek.gda.pl/avr/uisp/srecord.htm for format description
            # found header, [S0:2][count:2][address:4] ...[checksum:2]
            read_len = int(record[2:4], 16)
            
            # read text content
            header = ''
            for i in range(2, read_len-1):
                index = 4+2*i
                ch = chr(int(record[index:index+2], 16))
                header += ch
            
            print "Reading file %s ..." % header
        elif record.startswith('S3'):
               #S3 15 10 10 00 00 4E56000042804E5E4E754E560000487990
                record = record.strip()
                hexs = record[12:-2] # ignore code, count, address and checksum
                # split to get every pair of chars
                hexs = [hexs[i:i+2] for i in range(0, len(hexs)-1, 2)]
                
                # format nicely for C
                format = lambda x : "0x%s" % x
                buffer += "\t"
                buffer += ", ".join(map(format, hexs))
                buffer += ",\n"
    
    buffer += """\t};
""" 
                
    f.close()
    return buffer

if __name__ == '__main__':
    if len(sys.argv) != 3:
        print "ERROR usage: srec_to_c.py <output.c> <file.s19>"
        sys.exit(-1)
    
    srecs = read_srecord(sys.argv[2])
    
    output = open(sys.argv[1], 'w')
    output.write(srecs)
    output.close()