/**
 * CJDesign MCF5206 debugging routines
 * @author: Copyright 2009,2010 Thomas Reidemeister
 * @date: 2009.12.14
 * @file: debug.c
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "debug.h"

/**
 * Outputs a char on UART0 using TRAP15
 * @param c The character to print
 */
void debug_putch(char c)
    {
    /* Store registers */
    asm("move.l %d0, -(%a7)");
    asm("move.l %d1, -(%a7)");
    /* Load CHAR c into d1 */
    asm("move.l 8(%a6), %d1");
    /* Setup trap function */
    asm("move.l #0x13, %d0");
    asm("trap #15");
    /* Restore registers */
    asm("move.l %d1, (%a7)+");
    asm("move.l %d0, (%a7)+");
    }

/**
 * Outputs a string on UART0
 * @param str The string to print
 */
void debug_puts(char* str)
    {
    if ( str != 0 )
        while ( *str != '\0')
            debug_putch( *str++ );
    }

