/**
 * Boot-loader code example 
 * @author: Copyright 2009,2010 Thomas Reidemeister
 * @date: 2009.12.14
 * @file: bootloader.c
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "debug.h"
#include "bootloader.h"

/**
 * Main entry point for program.
 */
int main(void)
{
    debug_puts("Inside boot-loader test suite!\r\n");

    /* register test structure */
    TestFixture tests;
    __REGISTER_TEST__(&tests);
    /* execute a firmware function to test */
    tests.firmware_fun();

    debug_puts("Inside boot-loader again!\r\n");
    
    return 0;
}

